/*  Esercizio: implementare una classe ArrayDinamico che gestisce una array di numeri interi, e una classe Main che ne esegue il test.
    Questo array deve permettere di aggiungere e rimuovere elementi, deve quindi aumentare e diminuire la sua dimensione
    dinamicamente, quando richiesto.
    
    La classe ArrayDinamico conterrà:
         - attributo: un array di interi, per memorizzati i numeri interi,
         - metodi: inserisci(int val, int pos) che effettua l'inserimento di un intero in una certa posizione;
                   sostituisci(int val, int pos) che imposta l'intero val all'elemento in posizione pos;
                   rimuovi(int pos) che rimuove, se presente, l'elemento in posizione pos;
                   getNumElementi() che restituisce il numero di elementi presenti nell'array.
         - metodo opzionale: inserisciAllaFine(int pos) che inserisce l'elemento pos in ultima posizione;
                             toString() che restituisce una stringa descrittiva contenente gli elementi dell'array.
*/

public class ArrayDinamico
{
    int[] arr = new int[0];

    //metodo che inserisce un nuovo elemento in una certa posizione
    //la dimensione dell'array viene incrementata di 1
    public void inserisci(int val, int pos)
    {
        //si controlla che l'input sia un valore valido per l'array
        //la posizione arr.length è considerata valida per permettere l'inserimento di un elemento in ultima posizione
        if(pos < 0 || pos > arr.length)
            return;

        //si crea un array con una posizione in piu'
        int[] newArr = new int[arr.length +1];
        //si copiano tutti gli elementi nel nuovo array
        //fino alla posizione dell'elemento da inserire
        for(int i = 0; i < pos; i++)
            newArr[i] = arr[i];
        //si inserisce il nuovo elemento 'val' nella posizione 'pos'
        newArr[pos] = val;
        //si copia il resto dell'array, ma dall'array vecchio si copia l'elemento precedente
        //poiche' è stato aggiunto un nuovo elemento
        for(int i = pos + 1; i < newArr.length; i++)
            newArr[i] = arr[i - 1];
        //si salva il nuovo array nella variabile di istanza
        arr = newArr;
    }
    
    //metodo che inserisce un nuovo elemento alla fine dell'array
    //la dimensione dell'array viene incrementata di 1
    public void inserisciAllaFine(int val)
    {
        //da notare che è possibile richiamare il metodo inserisci, fornendo come parametri
        //il valore val e la posizione arr.length per indicare un inserimento in ultima posizione
        inserisci(val, arr.length);
    }
    
    //metodo che sostituisce un elemento dell'array in una certa posizione con un nuovo elemento
    //la dimensione dell'array non cambia
    public void sostituisci(int val, int pos)
    {
        //si controlla che l'input sia un valore valido per l'array
        if(pos < 0 || pos >= arr.length)
            return;
        //salvataggio dell'elemento nell'array, nella posizione indicata
        arr[pos] = val;
    }
    
    //metodo che rimuove un elemento dell'array in una certa posizione, se è presente almento un elemento
    //la dimensione dell'array viene decrementata di 1
    //es: arr={1, 2, 3, 4, 5}, pos=2 -> arr={1, 2, 4, 5};
    public int rimuovi(int pos)
    {
        //si controlla che l'input sia u valore valido per l'array
        if(pos < 0 || pos >= arr.length)
            return -1;
        //si controlla che l'array abbia almeno un elemento da rimuovere
        if(arr.length < 1)
            return -1;

        //si salva il primo elemento, che sara' ritornato dalla funzione
        int val = arr[pos];
        //si crea un array con una posizione in meno
        int[] newArr = new int[arr.length -1];
        //si copia l'array nel nuovo array, la parte che rimane invariata:
        //cioe' dall'inizio fino a pos
        for(int i = 0; i < pos; i++)
            newArr[i] = arr[i];
        //poi si continua a copiare da pos, ma dall'array vecchio si copia l'elemento successivo
        //poiche' l'elemento in posizione pos è stato rimosso
        for(int i = pos; i < newArr.length; i++)
            newArr[i] = arr[i + 1];
        //si salva il nuovo array nella variabile di istanza
        arr = newArr;
        //si restituisce l'elemento tolto
        return val;
    }
    
     //metodo che restituisce il numero di elementi
    public int getNumElementi()
    {
        return arr.length;
    }
    
    //metodo che restituisce una stringa contenente la lista degli elementi
    public String toString()
    {  
        String s = "{";
        if(arr.length > 0) {
            for(int i = 0; i < arr.length-1; i++)
                s += arr[i] + ", ";
            s += arr[arr.length-1];
        }
        s += "}";
        return s;
    }
}
